/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.helpers;

import com.oracle.cie.wizard.tasks.TaskContext;

public class SetTaskHelper {
    public static void setKeyOnTarget(TaskContext context, String namespace, Target target, String key, Object value) {
        if (target == Target.objectstore || target == Target.os_wf) {
            if (value == null) {
                context.removeObject(namespace, key);
            } else {
                context.storeObject(namespace, key, value);
            }
        }
        if (target == Target.workflow || target == Target.os_wf) {
            context.setWorkflowProperty(key, value == null ? null : value.toString());
        }
    }

    public static String getAttributeValue(TaskContext context, String namespace, AttrType type, String attrValue) {
        if (type == null) {
            return attrValue;
        }
        switch (type) {
            case os_key: {
                return context.getString(namespace, attrValue);
            }
            case os_subst: {
                return context.substitute(namespace, attrValue);
            }
            case rs_key: {
                return context.getI18nString(namespace, attrValue);
            }
            case rs_subst: {
                return context.subI18nString(namespace, attrValue);
            }
        }
        return attrValue;
    }

    public static enum Target {
        objectstore,
        workflow,
        os_wf;

    }

    public static enum AttrType {
        value,
        os_key,
        os_subst,
        rs_key,
        rs_subst;

    }
}

