/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.helpers;

import com.oracle.cie.wizard.helpers.IEvaluator;
import com.oracle.cie.wizard.tasks.TaskContext;
import java.io.File;
import java.util.logging.Logger;

public class CheckFileAttributesEvaluator
implements IEvaluator {
    protected Logger log = Logger.getLogger(this.getClass().getName());
    public static final String CHECK_TYPE_KEY = "CheckFileAttributesEvaluator.check.type.key";
    public static final String CHECK_FILENAME_KEY = "CheckFileAttributesEvaluator.check.filename.key";
    public static final int EXISTS_CHECK = 1;
    public static final int DIRECTORY_CHECK = 2;
    public static final int FILE_CHECK = 3;

    @Override
    public boolean evaluate(String namespace, TaskContext proxy) {
        boolean result = false;
        Integer checkType = (Integer)proxy.retrieveObject(namespace, CHECK_TYPE_KEY);
        int type = checkType == null ? 1 : checkType;
        String filename = (String)proxy.retrieveObject(namespace, CHECK_FILENAME_KEY);
        if (filename != null) {
            File f = new File(filename);
            switch (type) {
                case 1: {
                    this.log.finer("Checking to see if file: " + filename + " exists.");
                    result = f.exists();
                    break;
                }
                case 2: {
                    this.log.finer("Checking to see if file: " + filename + " is a directory.");
                    result = f.isDirectory();
                    break;
                }
                case 3: {
                    this.log.finer("Checking to see if file: " + filename + " is a file.");
                    result = f.isFile();
                    break;
                }
                default: {
                    this.log.severe("Unrecognized check type: " + type);
                    break;
                }
            }
        } else {
            this.log.severe("CheckFileAttributesEvaluator has no file to evaluate!");
        }
        this.log.finer("CheckFileAttributesEvaluator result is: " + result);
        proxy.removeObject(namespace, CHECK_TYPE_KEY);
        proxy.removeObject(namespace, CHECK_FILENAME_KEY);
        return result;
    }
}

