/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.gui.tasks;

import com.oracle.cie.common.ui.gui.GUIUtilities;
import com.oracle.cie.wizard.gui.GUITaskContext;
import com.oracle.cie.wizard.gui.tasks.AbstractGUITask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskDescription;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

@TaskDescription(name="message_gui")
public class MessageGUITask
extends AbstractGUITask {
    private String _message = "";
    private String _copyrightText = null;

    @TaskAttribute(required=true, type=TaskAttributeType.RESOURCE_KEY)
    public void setMessage(String msg) {
        this._message = msg;
    }

    @TaskAttribute(required=false, type=TaskAttributeType.RESOURCE_KEY)
    public void setCopyrightText(String copyrightText) {
        this._copyrightText = copyrightText;
    }

    @Override
    public JComponent createUI() {
        JPanel panel = new JPanel(new GridBagLayout());
        JTextPane messagePane = new JTextPane();
        HTMLEditorKit kit = GUIUtilities.getHTMLEditorKit((boolean)false);
        messagePane.setEditorKit(kit);
        messagePane.setEditable(false);
        messagePane.setOpaque(false);
        messagePane.setText(((GUITaskContext)this._context).subI18nString(this._namespace, this._message));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets.top = 16;
        gbc.insets.bottom = 8;
        gbc.insets.left = 10;
        gbc.insets.right = 8;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel.add((Component)messagePane, gbc);
        this._copyrightText = ((GUITaskContext)this._context).subI18nString(this._namespace, this._copyrightText);
        if (this._copyrightText != null && !this._copyrightText.isEmpty()) {
            JTextPane copyrightPane = new JTextPane();
            copyrightPane.setEditorKit(kit);
            copyrightPane.setEditable(false);
            copyrightPane.setOpaque(false);
            copyrightPane.setFocusable(false);
            copyrightPane.setText(this._copyrightText);
            gbc.anchor = 16;
            ++gbc.gridy;
            gbc.weighty = 0.0;
            gbc.insets.bottom = 10;
            panel.add((Component)copyrightPane, gbc);
        }
        messagePane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Desktop desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                    try {
                        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                            desktop.browse(e.getURL().toURI());
                        } else {
                            MessageGUITask.this._logger.log(Level.FINER, "Not able to get the default browser info.");
                        }
                    }
                    catch (Exception e1) {
                        MessageGUITask.this._logger.log(Level.FINER, "Error occurred in opening the external link", e1);
                    }
                }
            }
        });
        return panel;
    }

    @Override
    public boolean okPrev() {
        return true;
    }

    @Override
    public boolean okNext() {
        return true;
    }
}

