/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.gui.roadmap.impl;

import com.oracle.cie.wizard.ControllerProxy;
import com.oracle.cie.wizard.event.WizardTaskActionEvent;
import com.oracle.cie.wizard.event.WizardTaskActionListener;
import com.oracle.cie.wizard.gui.roadmap.Roadmap;
import com.oracle.cie.wizard.gui.roadmap.RoadmapMngmt;
import com.oracle.cie.wizard.gui.roadmap.RoadmapStep;
import com.oracle.cie.wizard.gui.roadmap.impl.CustomRoadmapNodeListRenderer;
import com.oracle.cie.wizard.gui.roadmap.impl.RoadmapListModelImpl;
import com.oracle.cie.wizard.gui.roadmap.impl.RoadmapStepImpl;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WizRoadmap
implements RoadmapMngmt,
Roadmap,
WizardTaskActionListener {
    private static final Logger logger = Logger.getLogger(WizRoadmap.class.getName());
    private ControllerProxy _proxy;
    private RoadmapListModelImpl _roadmapStepsList = null;
    private JList roadmapList = null;
    private boolean userSelectionEnabled = true;
    private int _selectedFocusedIndex = 0;
    private RoadmapListModelImpl.Direction directionFlow = RoadmapListModelImpl.Direction.FORWARD;
    private boolean taskNavigationDone = false;

    @Override
    public Roadmap getRoadmap() {
        return this;
    }

    @Override
    public JComponent getUI() {
        if (this.roadmapList == null) {
            this.roadmapList = this.constructRoadmapDisplayTree();
        }
        return this.roadmapList;
    }

    @Override
    public void init(ControllerProxy proxy) {
        this._proxy = proxy;
        this._roadmapStepsList = new RoadmapListModelImpl(this._proxy);
        this._proxy.addWizardWorkflowListener(this._roadmapStepsList);
        this._proxy.addWizardTaskActionListener(this);
    }

    private JList constructRoadmapDisplayTree() {
        this.roadmapList = new JList(this._roadmapStepsList);
        this.roadmapList.setOpaque(false);
        this.roadmapList.setSelectionMode(0);
        this.roadmapList.setSelectedIndex(0);
        this.roadmapList.setCellRenderer(new CustomRoadmapNodeListRenderer());
        this.roadmapList.setFixedCellHeight(-1);
        if (this.userSelectionEnabled) {
            this.roadmapList.addMouseListener(new CustomMouseListener());
            this.roadmapList.addKeyListener(new CustomKeyListener());
            this.roadmapList.getSelectionModel().addListSelectionListener(new CustomListSelectionListener());
            this.roadmapList.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    WizRoadmap.this.taskNavigationDone = false;
                }

                @Override
                public void focusGained(FocusEvent e) {
                    if (WizRoadmap.this.taskNavigationDone) {
                        WizRoadmap.this.roadmapList.getSelectionModel().setLeadSelectionIndex(WizRoadmap.this.getCurrentStepIndex());
                        WizRoadmap.this._selectedFocusedIndex = WizRoadmap.this._roadmapStepsList.getCurrentSelectedIndex();
                    }
                    WizRoadmap.this.roadmapList.requestFocusInWindow();
                }
            });
        }
        return this.roadmapList;
    }

    private boolean isStepActive(int index) {
        boolean isActive = true;
        if (this.userSelectionEnabled && this._roadmapStepsList != null && !this._roadmapStepsList.isEmpty()) {
            int startNavEnabledRange = this._roadmapStepsList.getStartNavEnabledRange();
            int endNavEnabledRange = this._roadmapStepsList.getEndNavEnabledRange();
            if (this._roadmapStepsList.isErrorState() && index >= this._roadmapStepsList.getCurrentSelectedIndex()) {
                return false;
            }
            if (index < startNavEnabledRange || index > endNavEnabledRange) {
                return false;
            }
        }
        return isActive;
    }

    @Override
    public RoadmapStep getCurrentStep() {
        RoadmapStep step = (RoadmapStep)this._roadmapStepsList.getElementAt(this._roadmapStepsList.getCurrentSelectedIndex());
        return step;
    }

    @Override
    public int getCurrentStepIndex() {
        return this._roadmapStepsList.getCurrentSelectedIndex();
    }

    @Override
    public int getSize() {
        return this._roadmapStepsList.getSize();
    }

    @Override
    public RoadmapStep getStepAt(int position) {
        return (RoadmapStep)this._roadmapStepsList.getElementAt(position);
    }

    @Override
    public List<RoadmapStep> getSteps() {
        ArrayList<RoadmapStep> steps = null;
        if (this._roadmapStepsList != null) {
            steps = new ArrayList<RoadmapStep>();
            for (int i = 0; i < this._roadmapStepsList.size() - 1; ++i) {
                steps.add((RoadmapStep)this._roadmapStepsList.get(i));
            }
        }
        return steps;
    }

    @Override
    public void enableUserInteraction(boolean isEnabled) {
        this.userSelectionEnabled = isEnabled;
    }

    @Override
    public boolean isUserInteractionEnabled() {
        return this.userSelectionEnabled;
    }

    @Override
    public void setErrorState(boolean isError) {
        this._roadmapStepsList.setErrorState(isError);
    }

    @Override
    public void enableForwardNavigation(boolean isEnabled) {
        this._roadmapStepsList.enableForwardNavigation(isEnabled);
    }

    @Override
    public void enableReverseNavigation(boolean isEnabled) {
        this._roadmapStepsList.enableReverseNavigation(isEnabled);
    }

    @Override
    public void setCurrentStepDisplayTitle(String title) {
        if (title != null && !title.isEmpty() && this._roadmapStepsList != null && !this._roadmapStepsList.isEmpty()) {
            int currentIndex = this._roadmapStepsList.getCurrentSelectedIndex();
            RoadmapStepImpl step = (RoadmapStepImpl)this._roadmapStepsList.getElementAt(currentIndex);
            step.setTaskTitle(title);
            this._roadmapStepsList.setElementAt(step, currentIndex);
        }
    }

    private void navigateToSelectedStep(int index) {
        RoadmapStepImpl roadmapStep = (RoadmapStepImpl)this._roadmapStepsList.getElementAt(index);
        if (roadmapStep.isActive()) {
            logger.finer(roadmapStep.getTaskTitle() + " Active step");
            this._proxy.goToTaskEntry(roadmapStep.getTaskEntry());
        } else {
            logger.finer("Disabled State: MouseClick/Selection of the roadmap Step is not allowed.");
        }
    }

    @Override
    public void taskActionPeformed(WizardTaskActionEvent event) {
        this._roadmapStepsList.taskActionPeformed(event);
        this.taskNavigationDone = true;
    }

    private class CustomMouseListener
    extends MouseAdapter {
        private CustomMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (WizRoadmap.this.userSelectionEnabled && WizRoadmap.this.roadmapList != null) {
                int index = WizRoadmap.this.roadmapList.locationToIndex(e.getPoint());
                if (index < WizRoadmap.this._roadmapStepsList.size() && WizRoadmap.this.isStepActive(index)) {
                    e.consume();
                    WizRoadmap.this.navigateToSelectedStep(index);
                } else {
                    WizRoadmap.this._selectedFocusedIndex = WizRoadmap.this._roadmapStepsList.getCurrentSelectedIndex();
                    e.consume();
                    logger.finer("InActive State: MouseClick of the roadmap Step is not allowed.");
                }
            }
        }
    }

    private class CustomKeyListener
    implements KeyListener {
        private CustomKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                if (WizRoadmap.this.roadmapList != null && WizRoadmap.this._roadmapStepsList != null && !WizRoadmap.this._roadmapStepsList.isEmpty() && WizRoadmap.this.roadmapList.hasFocus()) {
                    if (WizRoadmap.this._selectedFocusedIndex != WizRoadmap.this._roadmapStepsList.getCurrentSelectedIndex() && WizRoadmap.this._selectedFocusedIndex < WizRoadmap.this._roadmapStepsList.size() && WizRoadmap.this.isStepActive(WizRoadmap.this._selectedFocusedIndex)) {
                        e.consume();
                        WizRoadmap.this.navigateToSelectedStep(WizRoadmap.this._selectedFocusedIndex);
                    } else {
                        WizRoadmap.this._selectedFocusedIndex = WizRoadmap.this._roadmapStepsList.getCurrentSelectedIndex();
                        e.consume();
                        logger.finer("InActive State: Selection of the roadmap Step is not allowed.");
                    }
                }
            } else if (e.getKeyCode() == 38) {
                WizRoadmap.this.directionFlow = RoadmapListModelImpl.Direction.REVERSE;
                if (!WizRoadmap.this.isStepActive(WizRoadmap.this._selectedFocusedIndex)) {
                    WizRoadmap.this._selectedFocusedIndex = WizRoadmap.this._roadmapStepsList.getStartNavEnabledRange();
                    e.consume();
                }
            } else if (e.getKeyCode() == 40) {
                WizRoadmap.this.directionFlow = RoadmapListModelImpl.Direction.FORWARD;
                if (!WizRoadmap.this.isStepActive(WizRoadmap.this._selectedFocusedIndex + 1)) {
                    WizRoadmap.this._selectedFocusedIndex = WizRoadmap.this._roadmapStepsList.getEndNavEnabledRange();
                    e.consume();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    private class CustomListSelectionListener
    implements ListSelectionListener {
        private CustomListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (WizRoadmap.this.directionFlow == RoadmapListModelImpl.Direction.FORWARD) {
                WizRoadmap.this._selectedFocusedIndex = e.getLastIndex();
            } else if (WizRoadmap.this.directionFlow == RoadmapListModelImpl.Direction.REVERSE) {
                WizRoadmap.this._selectedFocusedIndex = e.getFirstIndex();
            }
        }
    }
}

