/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.ext.panel;

import com.oracle.cie.common.ui.gui.GUIUtilities;
import com.oracle.cie.common.util.ResourceBundleManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

public class FileTypeComponent
extends JPanel {
    private JTextField _textField;
    private String _namespace;
    private JButton _button;

    public FileTypeComponent(String namespace, int width) {
        this._namespace = namespace;
        this._textField = new JTextField();
        width = width == 0 ? this.getPreferredSize().width : width;
        this.init();
        this.setPreferredSize(new Dimension(width, this.getPreferredSize().height));
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this._button = new JButton();
        GUIUtilities.configureButton((AbstractButton)this._button, (String)this.getI18nString("FileComponent.button.text"));
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 0, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        gbc.fill = 2;
        this.add((Component)this._textField, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.insets.left = 8;
        gbc.fill = 0;
        this.add((Component)this._button, gbc);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedItem = FileTypeComponent.this._textField.getText();
                JFileChooser dlg = selectedItem != null ? new JFileChooser(new File(selectedItem.trim())) : new JFileChooser();
                String title = FileTypeComponent.this.getI18nString("FileComponent.filechooser.title");
                dlg.setDialogTitle(title);
                dlg.setFileSelectionMode(2);
                if (dlg.showOpenDialog(FileTypeComponent.this) == 0) {
                    String item = dlg.getSelectedFile().getAbsolutePath();
                    FileTypeComponent.this._textField.setText(item);
                }
            }
        };
        this._button.addActionListener(action);
    }

    String getValue() {
        return this._textField != null ? this._textField.getText() : null;
    }

    void setValue(Object obj) {
        this._textField.setText(obj != null ? obj.toString() : "");
    }

    private String getI18nString(String key) {
        String value = ResourceBundleManager.getString((String)this._namespace, (String)key);
        return value == null ? key : value;
    }

    public void addDocumentListener(DocumentListener listener) {
        if (this._textField != null) {
            this._textField.getDocument().addDocumentListener(listener);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._textField.setEnabled(enabled);
        this._button.setEnabled(enabled);
    }
}

