/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.ext.impl;

import com.oracle.cie.wizard.WizardConfiguration;
import com.oracle.cie.wizard.ext.OperationInput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OperationInputImpl
implements OperationInput {
    private WizardConfiguration _conf;
    private static OperationInputImpl _operationInput = null;
    private static final Map<String, Object> _variableMap = new HashMap<String, Object>();

    private OperationInputImpl(String namespace, WizardConfiguration conf) {
        this._conf = conf;
    }

    @Override
    public boolean isOptionSet(String optionName) {
        return this._conf.isOptionSet(optionName);
    }

    @Override
    public Object getVariableValue(String variableName) {
        return _variableMap.get(variableName);
    }

    @Override
    public String getOptionValue(String optionName) {
        return !this._conf.isOptionSet(optionName) ? null : this._conf.getOptionValue(optionName);
    }

    @Override
    public String getValue(String name) {
        Object value = this.getVariableValue(name);
        return value == null ? this.getOptionValue(name) : String.valueOf(value);
    }

    public Object addVariable(String name, Object value) {
        return _variableMap.put(name, value);
    }

    @Override
    public Map<String, Object> getAllVariables() {
        return Collections.unmodifiableMap(_variableMap);
    }

    public static synchronized OperationInput initialize(String nameSpace, WizardConfiguration conf) {
        if (_operationInput == null) {
            if (nameSpace == null || conf == null) {
                throw new IllegalArgumentException("Can not accept null argument (Arguments namespace:'" + nameSpace + "', or WizardConfiguration:" + conf + ")");
            }
            _operationInput = new OperationInputImpl(nameSpace, conf);
        }
        return _operationInput;
    }

    public static OperationInput getInstance() {
        return _operationInput;
    }

    public static synchronized boolean isInitialized() {
        return _operationInput != null;
    }
}

