/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard;

import com.oracle.cie.wizard.ConfigurationOption;
import java.util.List;
import java.util.Map;

public interface WizardConfiguration {
    public static final ConfigurationOption HELP = new ConfigurationOption("help", "Displays wizard usage.", "wizard.conf.option.help");
    public static final ConfigurationOption ARGS_FILE = new ConfigurationOption("args", "File to load wizard argumets from.", "wizard.conf.option.args");
    public static final ConfigurationOption MODE = new ConfigurationOption("mode", "Wizard execution mode. Supported values: {0}.", "wizard.conf.option.mode", new String[]{"gui", "silent"}, "gui");
    public static final ConfigurationOption CTRLFILE = new ConfigurationOption("wcf", "Wizard control file (WCF) to execute. If unset, {1} will be used.", "wizard.conf.option.wcf", "wizard.xml");
    public static final ConfigurationOption TARGET = new ConfigurationOption("target", "Target in a wizard control file (WCF) to run. If unset, a default target set in the WCF will be executed.", "wizard.conf.option.target");
    public static final ConfigurationOption LOGFILE = new ConfigurationOption("log", "Log file. The value can be a filename or one of the special values STDOUT, STDERR, or DISABLE.", "wizard.conf.option.log");
    public static final ConfigurationOption LOGPRIORITY = new ConfigurationOption("log_priority", "Log priority. Supported values: {0}.", "wizard.conf.option.log_priority", new String[]{"OFF", "SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST", "ALL"});
    public static final ConfigurationOption UI_CONTEXT_WIDTH = new ConfigurationOption("width", "Width of the wizard window. Only applicable in GUI mode.", "wizard.conf.option.width");
    public static final ConfigurationOption UI_CONTEXT_HEIGHT = new ConfigurationOption("height", "Height of the wizard window. Only applicable in GUI mode.", "wizard.conf.option.height");
    public static final ConfigurationOption RECORD = new ConfigurationOption("record", "Flag to indicate if user inputs has to be recorded in to the response file", "wizard.conf.option.record", new String[]{"true", "false"}, "false");
    public static final ConfigurationOption RESPONSE_FILE = new ConfigurationOption("responseFile", "Path of the file where the user input has to be written or to be read", "wizard.conf.option.response.file");

    public boolean isValid();

    public boolean isUsageRequested();

    public String getUsage();

    public List<String> getErrors();

    public List<String> getWarnings();

    public String getAllErrors();

    public List<String> getUnrecognized();

    public Map<String, String> getOptions();

    public String getOptionValue(ConfigurationOption var1);

    public String getOptionValue(String var1);

    public boolean isOptionSet(ConfigurationOption var1);

    public boolean isOptionSet(String var1);

    public List<String> getArguments();
}

