/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard;

import com.oracle.cie.common.util.ResourceBundleManager;
import java.util.MissingResourceException;

public class ConfigurationOption {
    private String _name;
    private boolean _isRequired;
    private String[] _allowedValues;
    private String _defaultValue;
    private String _descr;
    private String _descrKey;
    private ValueType _valueType;

    public ConfigurationOption(String name, String descr, String descKey) {
        this(name, descr, descKey, false, ValueType.SINGLE);
    }

    public ConfigurationOption(String name, String descr, String descKey, boolean required, ValueType valueType) {
        this(name, descr, descKey, null, null, required, valueType);
    }

    public ConfigurationOption(String name, String descr, String descKey, String[] allowedValues) {
        this(name, descr, descKey, allowedValues, false);
    }

    public ConfigurationOption(String name, String descr, String descKey, String defaultValue) {
        this(name, descr, descKey, null, defaultValue);
    }

    protected ConfigurationOption(String name, String descr, String descrKey, String[] allowedValues, boolean required) {
        this(name, descr, descrKey, allowedValues, null, required, ValueType.SINGLE);
    }

    public ConfigurationOption(String name, String descr, String descrKey, String[] allowedValues, String defaultValue) {
        this(name, descr, descrKey, allowedValues, defaultValue, false, ValueType.SINGLE);
    }

    public ConfigurationOption(String name, String descr, String descrKey, String[] allowedValues, String defaultValue, boolean required, ValueType valueType) {
        this._name = name;
        this._descr = descr;
        this._descrKey = descrKey;
        this._allowedValues = allowedValues;
        this._defaultValue = defaultValue;
        this._isRequired = required;
        this._valueType = valueType;
        if (this._valueType == ValueType.NO_VALUE && (this._defaultValue != null || this._allowedValues != null && this._allowedValues.length > 0)) {
            throw new IllegalArgumentException("Default or allowed values information is not supported for a NO VALUE option:" + name);
        }
    }

    public String getName() {
        return this._name;
    }

    public String getDescr() {
        String descr = null;
        if (this._descrKey != null) {
            try {
                descr = ResourceBundleManager.getString((String)"wizard-internal", (String)this._descrKey);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (descr == null || descr.isEmpty()) {
            descr = this._descr;
        }
        return descr;
    }

    public String getDescrKey() {
        return this._descrKey;
    }

    public boolean isRequired() {
        return this._isRequired;
    }

    public String[] getAllowedValues() {
        return this._allowedValues;
    }

    public void setAllowedValues(String[] allowedValues) {
        this._allowedValues = allowedValues;
    }

    public boolean hasDefault() {
        return this._defaultValue != null;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public ValueType getValueType() {
        return this._valueType;
    }

    public static enum ValueType {
        SINGLE,
        NO_VALUE,
        MULTI_VALUE;

    }
}

