/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.wallet;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.services.ClassLoaderService;
import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.wallet.WalletHandler;
import com.oracle.cie.wallet.WalletHandlerException;
import com.oracle.cie.wallet.WalletHandlerFactory;
import com.oracle.glcm.patch.wallet.WalletConfiguration;
import com.oracle.glcm.patch.wallet.commandline.CommandLineHolder;
import com.oracle.glcm.patch.wallet.commandline.ConfigurationOption;
import com.oracle.glcm.patch.wallet.commandline.Operation;
import com.oracle.glcm.patch.wallet.commandline.OperationArgumentException;
import com.oracle.glcm.patch.wallet.commandline.validator.UserNameValidator;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WalletTool
extends Operation {
    private static final String OPATCH_AUTO_WALLET_NAMESPACE = "opatchauto-wallet";
    private static final String DEFAULT_LOG_DIR = "cfgtoollogs";
    private static final String KEY_STORE_CONSTANT = "@#3#@";
    private static final String SEPERATOR = ":";
    private static final int BUF_SIZE = 1028;
    private static final Logger logger = Logger.getLogger(WalletTool.class.getName());
    private static final String LOG_PRIORITY_DFLT = "info";
    private Console _console;
    private BufferedReader _stdInReader;
    private boolean _useStdin = false;
    private boolean _overwrite = false;
    private String _map = "oracle";
    private WalletHandler _walletHandler;
    private String _toolVersion;
    private String _home;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int rc = 0;
        try (WalletTool tool = new WalletTool();){
            tool.run(args);
        }
        if (!Boolean.getBoolean("WalletTool.disable.system.exit")) {
            System.exit(rc);
        } else if (rc != 0) {
            throw new IllegalStateException("WalletTool failed with non-zero exit code.");
        }
    }

    private void close() {
        if (this._walletHandler != null) {
            this._walletHandler.close();
        }
        this._walletHandler = null;
    }

    @Override
    protected String getHelpMessageTitle() {
        StringBuilder builder = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        builder.append(WalletTool.getI18nString("WalletTool.conf.help.title.text"));
        builder.append(lineSeparator);
        builder.append("   [ options ] { -create | -delete | -list } alias ...");
        builder.append(lineSeparator);
        builder.append("    Supported alias format ::  <userName>:<hostName>{:}{/}<protocol>");
        builder.append(lineSeparator);
        builder.append("    Examples : ");
        builder.append(lineSeparator);
        builder.append("   \t\t\tabc:xyz:ssh");
        builder.append(lineSeparator);
        builder.append("   \t\t\tabc:xyz/ssh");
        builder.append(lineSeparator);
        return builder.toString();
    }

    @Override
    protected List<ConfigurationOption> getHelpDisplayOptions() {
        ArrayList<ConfigurationOption> options = new ArrayList<ConfigurationOption>();
        for (SupportedParam opt : SupportedParam.values()) {
            options.add(opt.getConfigOption());
        }
        return options;
    }

    private void run(String[] args) throws Exception {
        CommandLineHolder holder;
        if (args.length == 0) {
            throw new IllegalArgumentException(WalletTool.getI18nString("Operation.error.no.args"));
        }
        if (this.isHelpRequested(args)) {
            System.out.println(this.getUsage());
            return;
        }
        try {
            holder = this.parse(args, this.getHelpDisplayOptions());
        }
        catch (OperationArgumentException e) {
            List<String> invalidArgs = e.getInvalidArgs();
            throw new IllegalArgumentException(invalidArgs != null && !invalidArgs.isEmpty() ? WalletTool.getI18nString("Operation.error.invalid.option", e.getInvalidArgs()) : WalletTool.getI18nString("Operation.error.invalid.value"));
        }
        Map<ConfigurationOption.ValueType, Map<String, List<String>>> parsedOptionMap = holder.getParsedOptions();
        Command command = null;
        String walletDir = null;
        boolean walletPasswordPrompt = false;
        String log = this.getDefaultLogFileLocation(this.getHome());
        String logLevel = LOG_PRIORITY_DFLT;
        LinkedHashSet<String> aliases = new LinkedHashSet<String>();
        for (ConfigurationOption.ValueType valueType : ConfigurationOption.ValueType.values()) {
            block19: for (Map.Entry<String, List<String>> entry : parsedOptionMap.get((Object)valueType).entrySet()) {
                SupportedParam param = SupportedParam.getSupportedParam(entry.getKey());
                switch (param) {
                    case WALLET_DIR_PARAM: {
                        walletDir = this.getSingleValue(entry.getValue());
                        continue block19;
                    }
                    case WALLET_PASSWORD_PARAM: {
                        walletPasswordPrompt = true;
                        continue block19;
                    }
                    case CREATE_PARAM: 
                    case DELETE_PARAM: 
                    case LIST_PARAM: 
                    case LIST_MAP_PARAM: {
                        List<String> aliasList = entry.getValue();
                        if (aliasList != null && !aliasList.isEmpty()) {
                            aliases.addAll(aliasList);
                        }
                        if (command != null) {
                            throw new IllegalArgumentException(WalletTool.getI18nString("WalletTool.command.mutually.exclusive"));
                        }
                        command = WalletTool.optionCmd(param);
                        continue block19;
                    }
                    case LOG_FILE_PARAM: {
                        log = this.getSingleValue(entry.getValue());
                        continue block19;
                    }
                    case LOG_PRIORITY_PARAM: {
                        logLevel = this.getSingleValue(entry.getValue());
                        continue block19;
                    }
                    case USE_STDIN_PARAM: {
                        this._useStdin = true;
                        continue block19;
                    }
                    case MAP_NAME_PARAM: {
                        this._map = this.getSingleValue(entry.getValue());
                        if (!StringUtil.isNullOrEmpty((String)this._map)) continue block19;
                        throw new IllegalArgumentException(WalletTool.getI18nString("Operation.error.invalid.map"));
                    }
                    case FORCE_PARAM: {
                        this._overwrite = true;
                        continue block19;
                    }
                }
                throw new IllegalArgumentException(WalletTool.getI18nString("Operation.error.invalid.option", entry.getKey()));
            }
        }
        LogFactory.getFactory().setupLogging(log, logLevel, true, new String[0]);
        System.out.println(WalletTool.getI18nString("WalletTool.session.log.file", log));
        logger.info("WalletTool version: " + this.getToolVersion());
        logger.info("Start WalletTool:  walletDir=" + walletDir);
        File walletDirFile = new File(walletDir);
        if (walletPasswordPrompt && this.getWalletHandler().walletExists(walletDirFile, true)) {
            throw new WalletHandlerException(WalletTool.getI18nString("WalletTool.autologin.wallet.exists", walletDir, "-" + SupportedParam.WALLET_PASSWORD_PARAM.getConfigOption().getName()));
        }
        if (!walletPasswordPrompt && this.getWalletHandler().walletExists(walletDirFile, false)) {
            throw new WalletHandlerException(WalletTool.getI18nString("WalletTool.password.wallet.exists", walletDir, "-" + SupportedParam.WALLET_PASSWORD_PARAM.getConfigOption().getName()));
        }
        char[] walletPassword = null;
        if (walletPasswordPrompt) {
            boolean confirm = command == Command.SetSecret && !this.getWalletHandler().walletExists(walletDirFile, false);
            walletPassword = this.getUserPw(WalletTool.getI18nString("WalletTool.alias.wallet"), confirm);
        }
        if (command == null) {
            command = Command.SetSecret;
        }
        switch (command) {
            case ListAliases: {
                WalletHandler wallet = this.load(walletDir, walletPassword);
                this.listAliases(wallet);
                break;
            }
            case ListMaps: {
                WalletHandler wallet = this.load(walletDir, walletPassword);
                this.listMaps(wallet);
                break;
            }
            case SetSecret: {
                if (aliases.isEmpty()) {
                    System.err.println(WalletTool.getI18nString("WalletTool.missing.aliases"));
                    break;
                }
                WalletHandler wallet = this.createWallet(walletDir, walletPassword);
                this.createAliases(wallet, aliases);
                break;
            }
            case UnsetSecret: {
                if (aliases.isEmpty()) {
                    System.err.println(WalletTool.getI18nString("WalletTool.missing.aliases"));
                    break;
                }
                WalletHandler wallet = this.load(walletDir, walletPassword);
                this.deleteAliases(wallet, aliases);
                break;
            }
            default: {
                System.out.println(this.getUsage());
                System.err.println(WalletTool.getI18nString("WalletTool.missing.command"));
            }
        }
    }

    private String getToolVersion() {
        if (this._toolVersion == null) {
            try {
                Manifest manifest = null;
                File myLocation = ClassLoaderService.getInstance().locateClass(WalletTool.class, WalletTool.class.getClassLoader());
                if (myLocation.getName().endsWith(".jar") && !myLocation.isDirectory()) {
                    JarFile jar = new JarFile(myLocation);
                    manifest = jar.getManifest();
                    jar.close();
                } else {
                    String path = myLocation.getAbsolutePath();
                    File manifestFile = new File(myLocation = new File(path.substring(0, path.length() - (WalletTool.class.getName().length() + 6))), "META-INF/MANIFEST.MF");
                    if (manifestFile.exists()) {
                        FileInputStream fis = new FileInputStream(manifestFile);
                        manifest = new Manifest(fis);
                        fis.close();
                    }
                }
                if (manifest != null) {
                    Attributes attributes = manifest.getMainAttributes();
                    this._toolVersion = attributes.getValue("Patch-Version");
                    if (StringUtil.isNullOrEmpty((String)this._toolVersion)) {
                        this._toolVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    }
                }
            }
            catch (IOException e) {
                logger.log(Level.FINEST, "Failed to get WalletTool version.", e);
            }
            if (this._toolVersion != null) {
                String[] split = this._toolVersion.split("\\.");
                for (int x = split.length; x < 5; ++x) {
                    this._toolVersion = this._toolVersion + ".0";
                }
            }
        }
        return this._toolVersion;
    }

    private String getHome() {
        if (this._home == null) {
            this._home = System.getProperty("OPatchAuto.HOME");
            if (StringUtil.isNullOrEmpty((String)this._home, (boolean)true)) {
                try {
                    File runningJar = ClassLoaderService.getInstance().locateClass(WalletTool.class);
                    if (runningJar.isFile() && runningJar.getName().endsWith(".jar")) {
                        this._home = runningJar.getParentFile().getParentFile().getParent();
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to determine WalletTool home.", e);
                }
            }
            if (!StringUtil.isNullOrEmpty((String)this._home, (boolean)true) && ComdevHelper.isWindows()) {
                this._home = IOUtil.getFile((String)this._home).getPath();
            }
        }
        return this._home;
    }

    private String getDefaultLogFileLocation(String home) {
        if (home == null || home.isEmpty()) {
            home = ".";
        }
        return home + File.separator + DEFAULT_LOG_DIR + File.separator + OPATCH_AUTO_WALLET_NAMESPACE + File.separator + OPATCH_AUTO_WALLET_NAMESPACE + new SimpleDateFormat("yyyy-MM-dd_hh-mm-ssa", Locale.ENGLISH).format(new Date()) + ".log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAliases(WalletHandler wallet, Set<String> aliases) throws WalletHandlerException {
        UserNameValidator usrNameValidator = new UserNameValidator();
        int allInvalidEntries = 0;
        for (String alias : aliases) {
            boolean isValid = usrNameValidator.validate(alias, false);
            if (!isValid) {
                ++allInvalidEntries;
                logger.log(Level.SEVERE, WalletTool.getI18nString("WalletTool.alias.invalid.value", alias));
                System.err.println(WalletTool.getI18nString("WalletTool.alias.invalid.value", alias));
                continue;
            }
            String[] usrNameAndOldKey = this.getUsrNameAndOldKey(alias, true);
            String userName = usrNameAndOldKey[0];
            String oldKey = usrNameAndOldKey[1];
            char[] pw = this.getUserPw(alias);
            try {
                boolean create = false;
                try {
                    wallet.getUsernameCredential(this._map, alias);
                }
                catch (WalletHandlerException e) {
                    create = true;
                }
                if (!this._overwrite && !create) {
                    logger.info("Alias already exists in wallet (skipping): " + alias);
                    System.err.println(WalletTool.getI18nString("WalletTool.alias.exists", alias));
                    continue;
                }
                if (create) {
                    wallet.createUserCredential(this._map, alias, userName, pw);
                } else {
                    wallet.modifyUserCredential(this._map, alias, userName, pw);
                }
                if (alias.equals(oldKey)) continue;
                StringBuilder storedKey = new StringBuilder(this._map);
                storedKey.append(KEY_STORE_CONSTANT).append(oldKey);
                if (!wallet.containsAlias(storedKey.toString())) continue;
                wallet.deleteUserCredential(this._map, oldKey);
            }
            finally {
                Arrays.fill(pw, '\u0000');
            }
        }
        try {
            if (allInvalidEntries < aliases.size()) {
                wallet.saveWallet();
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "I/O error saving wallet", ioe);
            throw new WalletHandlerException(WalletTool.getI18nString("WalletTool.error.saving.wallet"), (Throwable)ioe);
        }
    }

    private String[] getUsrNameAndOldKey(String alias, boolean userRequired) {
        int counter = alias.split(SEPERATOR).length;
        String[] data = new String[2];
        if (counter == 3 || userRequired) {
            String usrName;
            int startIndex = alias.indexOf(58);
            String key = alias.substring(startIndex + 1, alias.length());
            data[0] = usrName = alias.substring(0, startIndex);
            data[1] = key;
        } else {
            data[1] = alias;
        }
        return data;
    }

    private void deleteAliases(WalletHandler wallet, Set<String> aliases) throws WalletHandlerException {
        int allInvalidEntries = 0;
        UserNameValidator usrNameValidator = new UserNameValidator();
        for (String alias : aliases) {
            boolean isValid = usrNameValidator.validate(alias, true);
            if (!isValid) {
                ++allInvalidEntries;
                logger.log(Level.SEVERE, WalletTool.getI18nString("WalletTool.alias.invalid.value", alias));
                System.err.println(WalletTool.getI18nString("WalletTool.alias.invalid.value", alias));
                continue;
            }
            String oldKey = this.getUsrNameAndOldKey(alias, false)[1];
            StringBuilder storedKey = new StringBuilder(this._map);
            storedKey.append(KEY_STORE_CONSTANT).append(alias);
            if (wallet.containsAlias(storedKey.toString())) {
                wallet.deleteUserCredential(this._map, alias);
                continue;
            }
            boolean missing = true;
            if (!alias.equals(oldKey) && wallet.containsAlias((storedKey = new StringBuilder(this._map).append(KEY_STORE_CONSTANT).append(oldKey)).toString())) {
                missing = false;
                wallet.deleteUserCredential(this._map, oldKey);
            }
            if (!missing) continue;
            logger.log(Level.WARNING, WalletTool.getI18nString("WalletTool.alias.not.exists", alias));
            System.out.println(WalletTool.getI18nString("WalletTool.alias.not.exists", alias));
        }
        try {
            if (allInvalidEntries < aliases.size()) {
                wallet.saveWallet();
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "I/O error saving wallet", ioe);
            throw new WalletHandlerException(WalletTool.getI18nString("WalletTool.error.saving.wallet"), (Throwable)ioe);
        }
    }

    private void listAliases(WalletHandler wallet) throws WalletHandlerException {
        try {
            for (String alias : wallet.listAliases()) {
                String[] aliasArray = alias.split(KEY_STORE_CONSTANT);
                String map = aliasArray[0];
                if (!map.equals(this._map)) continue;
                String key = aliasArray[1];
                System.out.println("Alias :: " + key);
            }
        }
        catch (WalletHandlerException e) {
            logger.log(Level.SEVERE, "Failed to get aliases from wallet", e);
            throw e;
        }
    }

    private void listMaps(WalletHandler wallet) throws WalletHandlerException {
        try {
            LinkedHashSet<String> mapSet = new LinkedHashSet<String>();
            for (String alias : wallet.listAliases()) {
                String[] aliasArray = alias.split(KEY_STORE_CONSTANT);
                String map = aliasArray[0];
                mapSet.add(map);
            }
            if (mapSet.isEmpty()) {
                System.out.println(WalletTool.getI18nString("WalletTool.maps.not.available"));
            } else {
                System.out.println(WalletTool.getI18nString("WalletTool.available.maps", ((Object)mapSet).toString()));
            }
        }
        catch (WalletHandlerException e) {
            logger.log(Level.SEVERE, "Failed to get maps from wallet", e);
            throw e;
        }
    }

    private static char[] readln(BufferedReader reader) throws IOException {
        try {
            return IOUtil.readLineChars((Reader)reader, (int)1028);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException(WalletTool.getI18nString("WalletTool.error.password.too.long"), e);
        }
    }

    private WalletHandler createWallet(String dir, char[] password) throws WalletHandlerException {
        WalletHandler wallet;
        File walletDir = null;
        if (dir != null && !(walletDir = new File(dir)).exists()) {
            walletDir.mkdirs();
        }
        try {
            wallet = this.getWalletHandler();
            if (password != null && password.length > 0) {
                wallet.createWallet(walletDir, password);
            } else {
                wallet.createWallet(walletDir);
            }
        }
        catch (WalletHandlerException whe) {
            logger.log(Level.SEVERE, "Error creating wallet", whe);
            System.err.println(WalletTool.getI18nString("WalletTool.error.wallet.creation", walletDir == null ? "[default]" : walletDir));
            throw whe;
        }
        return wallet;
    }

    private WalletHandler load(String dir, char[] password) throws WalletHandlerException {
        WalletHandler wallet;
        File walletDir = null;
        if (dir != null) {
            walletDir = new File(dir);
        }
        try {
            wallet = this.getWalletHandler();
            if (password != null && password.length > 0) {
                wallet.loadWallet(walletDir, password);
            } else {
                wallet.loadWallet(walletDir);
            }
        }
        catch (WalletHandlerException whe) {
            logger.log(Level.SEVERE, "Failed to load wallet", whe);
            System.err.println(WalletTool.getI18nString("WalletTool.error.invalid.wallet.dir", walletDir == null ? "[default]" : walletDir));
            throw whe;
        }
        return wallet;
    }

    private WalletHandler getWalletHandler() throws WalletHandlerException {
        if (this._walletHandler == null) {
            this._walletHandler = WalletHandlerFactory.getWalletHandler();
        }
        return this._walletHandler;
    }

    private char[] getUserPw(String alias) throws WalletHandlerException {
        return this.getUserPw(alias, true);
    }

    private char[] getUserPw(String alias, boolean confirm) throws WalletHandlerException {
        if (!this._useStdin && this._console == null) {
            this._console = System.console();
        }
        if (this._useStdin || this._console == null) {
            if (this._stdInReader == null) {
                this._stdInReader = new BufferedReader(new InputStreamReader(System.in));
            }
            try {
                return WalletTool.readln(this._stdInReader);
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "Failed to read password from stdin", ioe);
                throw new WalletHandlerException(WalletTool.getI18nString("WalletTool.error.reading.password"), (Throwable)ioe);
            }
        }
        while (true) {
            char[] pw = this._console.readPassword(WalletTool.getI18nString("WalletTool.enter.password"), alias);
            if (!confirm) {
                return pw;
            }
            if (pw.length > 0) {
                char[] pw2 = this._console.readPassword(WalletTool.getI18nString("WalletTool.confirm.password"), alias);
                if (Arrays.equals(pw, pw2)) {
                    Arrays.fill(pw2, '\u0000');
                    return pw;
                }
                System.err.println(WalletTool.getI18nString("WalletTool.error.password.mismatch"));
                continue;
            }
            System.err.println(WalletTool.getI18nString("WalletTool.error.missing.password"));
        }
    }

    private static Command optionCmd(SupportedParam opt) {
        switch (opt) {
            case LIST_PARAM: {
                return Command.ListAliases;
            }
            case LIST_MAP_PARAM: {
                return Command.ListMaps;
            }
            case CREATE_PARAM: {
                return Command.SetSecret;
            }
            case DELETE_PARAM: {
                return Command.UnsetSecret;
            }
        }
        return Command.None;
    }

    @Override
    protected void validateHolder(CommandLineHolder holder) throws OperationArgumentException {
        super.validateHolder(holder);
        this.validateRequiredArgs(holder);
        Set<String> createNDeleteArgs = holder.getParsedOptions().get((Object)ConfigurationOption.ValueType.MULTI_VALUE).keySet();
        boolean isDeleteOperation = createNDeleteArgs.contains(WalletConfiguration.DELETE.getName());
        boolean isCreateOperation = createNDeleteArgs.contains(WalletConfiguration.CREATE.getName());
        if ((isCreateOperation || isDeleteOperation) && holder.getParsedOptions().get((Object)ConfigurationOption.ValueType.MULTI_VALUE).isEmpty()) {
            ArrayList<String> invalidArgs = new ArrayList<String>();
            invalidArgs.addAll(holder.getParsedOptions().get((Object)ConfigurationOption.ValueType.MULTI_VALUE).keySet());
            throw new OperationArgumentException(invalidArgs);
        }
        if (!holder.getErrorMessages().isEmpty()) {
            for (String errMessage : holder.getErrorMessages()) {
                System.out.println(errMessage);
            }
            throw new OperationArgumentException(Collections.emptyList());
        }
    }

    private void validateRequiredArgs(CommandLineHolder holder) {
        ArrayList<String> parsedArguments = new ArrayList<String>();
        parsedArguments.addAll(holder.getParsedOptions().get((Object)ConfigurationOption.ValueType.MULTI_VALUE).keySet());
        parsedArguments.addAll(holder.getParsedOptions().get((Object)ConfigurationOption.ValueType.SINGLE).keySet());
        parsedArguments.addAll(holder.getParsedOptions().get((Object)ConfigurationOption.ValueType.NO_VALUE).keySet());
        for (SupportedParam opt : SupportedParam.values()) {
            ConfigurationOption configOpt = opt.getConfigOption();
            if (!configOpt.isRequired() || parsedArguments.contains(configOpt.getName())) continue;
            holder.getErrorMessages().add(WalletTool.getI18nString("WalletTool.conf.error.required.option", "-" + configOpt.getName()));
        }
    }

    private static enum Command {
        None,
        ListAliases,
        ListMaps,
        SetSecret,
        UnsetSecret;

    }

    private static enum SupportedParam {
        WALLET_DIR_PARAM(WalletConfiguration.WALLET_DIR),
        WALLET_PASSWORD_PARAM(WalletConfiguration.WALLET_PASSWORD),
        USE_STDIN_PARAM(WalletConfiguration.USE_STDIN),
        MAP_NAME_PARAM(WalletConfiguration.MAP_NAME),
        FORCE_PARAM(WalletConfiguration.FORCE),
        LIST_PARAM(WalletConfiguration.LIST),
        LIST_MAP_PARAM(WalletConfiguration.LIST_MAP),
        CREATE_PARAM(WalletConfiguration.CREATE),
        DELETE_PARAM(WalletConfiguration.DELETE),
        LOG_PRIORITY_PARAM(WalletConfiguration.LOGPRIORITY),
        LOG_FILE_PARAM(WalletConfiguration.LOGFILE),
        HELP_PARAM(WalletConfiguration.HELP);

        private final ConfigurationOption _configOption;

        private SupportedParam(ConfigurationOption option) {
            this._configOption = option;
        }

        ConfigurationOption getConfigOption() {
            return this._configOption;
        }

        String getName() {
            return this._configOption.getName();
        }

        static SupportedParam getSupportedParam(String name) {
            for (SupportedParam param : SupportedParam.values()) {
                if (!param.getName().equals(name)) continue;
                return param;
            }
            throw new IllegalArgumentException(WalletTool.getI18nString("Operation.error.invalid.option", new Object[]{name}));
        }
    }
}

