SET SERVEROUTPUT ON

REM Apply script for patch 33795989/25491938
DEFINE logfiledir = &1

COLUMN sqlpatch_logfile NEW_VALUE full_logfile

SELECT '&logfiledir' || '33795989_rollback_' ||
       CASE WHEN (sys_context('userenv', 'cdb_name') IS NULL) 
            THEN name
            ELSE name || '_' || replace(sys_context('userenv', 'con_name'), '$')
             END || TO_CHAR(systimestamp, '_YYYYMonDD_HH24_MI_SS',
             'NLS_DATE_LANGUAGE=AMERICAN') ||'.log' AS sqlpatch_logfile
  FROM v$database;

SPOOL &full_logfile

SET PAGESIZE 0
SELECT 'Starting rollback for patch 33795989/25491938 on ' ||
       SYSTIMESTAMP FROM dual;
SET PAGESIZE 10

BEGIN
    dbms_sqlpatch.patch_initialize(p_patch_id      => 33795989,
                                   p_patch_uid     => 25491938,
                                   p_logfile       => '&full_logfile');
END;
/


COLUMN install_file NEW_VALUE sql_script




BEGIN dbms_sqlpatch.patch_finalize; END;
/

SET PAGESIZE 0
SELECT 'Finished rollback for patch 33795989/25491938 on' ||
       SYSTIMESTAMP FROM dual;
SET PAGESIZE 10

SPOOL off

